package net.w_horse.excelpojo.annotation;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;

import test.annotation.AnnotationTestRangeLabeledCell;
import test.annotation.LabeledCellMargedLabel;
import test.annotation.LabeledCellRetrieveFrom;
import test.annotation.LabeledCellUseRequired;
import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.excel.CellNotFoundException;

public class LabeledCellTest extends AbstractTest {
	/**
	 * ꂽxɂf[^擾imargedLabelj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellMargedLabel() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellMargedLabel.class);
		LabeledCellMargedLabel targetBean = (LabeledCellMargedLabel) bridge.load("./files/upload/ParserTest.xls", "Users2");

		assertEquals("{i擾jFLabeledCellFString", "Xg", targetBean.getRetrievMargedLable0());
		assertEquals("{i擾jFLabeledCellFString", "ExcelPOJỎ", targetBean.getRetrievMargedLable1());
		assertEquals("{i擾jFLabeledCellFString", "XgiQj", targetBean.getRetrievMargedLableNone());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"Users2",
				"./files/export/AnnotationParserTest_xA.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_xA.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("Users2");

			assertEquals("{i݁jFLabeledCellFString", "Xg", getCellValue(sheet, 1, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "ExcelPOJỎ", getCellValue(sheet, 2, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "XgiQj", getCellValue(sheet, 1, 5, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * x̓ǂݍ݂ɕK{wiuse=requiredjw肵ۂ̓eXg
	 * K{Y\Ȃꍇ˗O
	 */
	@Test(expected=CellNotFoundException.class)
	public void testReadAndSaveLabeledCellUseRequired() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellUseRequired.class);
		@SuppressWarnings("unused")
		LabeledCellUseRequired targetBean = (LabeledCellUseRequired) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");
	}

	/**
	 * xɂʒuɑ΂Af[^擾ʒuiretrieveFromj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellRetrieveFrom() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellRetrieveFrom.class);
		LabeledCellRetrieveFrom targetBean = (LabeledCellRetrieveFrom) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");

		assertEquals("{i擾jFLabeledCellFString", "Ẽf[^", targetBean.getRetrievFromRight());
		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getRetrievFromBottom());
		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getRetrievFromLeft());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"xǂݍ݈ʒu",
				"./files/export/AnnotationParserTest_xǂݍ݈ʒu.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_xǂݍ݈ʒu.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("xǂݍ݈ʒu");

			assertEquals("{i݁jFLabeledCellFString", "Ẽf[^", getCellValue(sheet, 4, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 4, 2, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * ͈͎w茟̃eXg
	 * xɑ΂w̏ꍇiK{ɂĂ̂Ōsv̏ꍇ͗Oj
	 * @throws ExcelPOJOException
	 */
	@Test(expected=CellNotFoundException.class)
	public void testRangeLabeledCell() throws ExcelPOJOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestRangeLabeledCell.class);
		@SuppressWarnings("unused")
		AnnotationTestRangeLabeledCell targetBean = (AnnotationTestRangeLabeledCell) bridge.load("./files/upload/ParserTest.xls", "{");
	}


}
